############### ###############
## 08 - analysis - distributions
## Project: CBO
## Author: Kamil Kouhen
## Purpose: Creating plots with distributions of outcome variables that are displayed in publications
## Date of creation: 18/01/2022
############### ###############

### Creating uniform path
path <- here("Output/For Publication/Figures/F_")

# 1. A_Breadth_of_engagement --------------- ######
  ggplot(CBO_groups_final,
                  aes(x = A_Breadth_of_engagement)) + 
     geom_histogram(binwidth = 1) + 
     labs(
       x = "Breadth of CBO engagement in municipal governance: \n Number of different types of involvement in municipal governance", 
       y = "Number of CBOs"
     ) + 
     theme_minimal() +
     theme(text = element_text(size=11, family="Times"))
  
  ggsave(width = 7, height = 3, filename = paste0(path, "H1_", "A_Breadth_of_engagement.png"), device = png,  dpi=200)
  

# 2. A_Intensity_of_engagement --------------- ######
  
  ggplot(CBO_groups_final,
                  aes(x = A_Intensity_of_engagement)) + 
      geom_histogram(binwidth = 0.1) + 
      labs(
        x = "Intensity of engagement in municipal governance: Z-score average index", 
        y = "Number of CBOs"
      ) +
      theme_minimal() +
      theme(text = element_text(size=11, family="Times"))  +
    theme(plot.margin=grid::unit(c(0,0,0,0), "mm"))
  
  ggsave(width = 7, height = 3, filename = paste0(path, "H1_", "A_Intensity_of_engagement.png"), device = png,  dpi=200)
  
  
# 3. A_DM_know_and_inter --------------- ######
  
  forplot <- DM_finalx2 %>%
    select(A_DM_know_and_inter, respondent_type) %>%
    replace(is.na(.), -999) %>%
    mutate(A_DM_know_and_inter = as.character(A_DM_know_and_inter)) %>%
    mutate(todrop_color = case_when(
      A_DM_know_and_inter == -999 ~ "Missing")) 
  
  ### Duplicating dataset to be able to show respondent and all together
  # in one graph only 
  rbind(forplot, forplot %>% mutate(respondent_type = "All Together")) %>%
    select(A_DM_know_and_inter, respondent_type) %>%
    group_by(respondent_type, A_DM_know_and_inter) %>% 
    summarise(n = n()) %>% 
    mutate(proportion = round((n/ sum(n))*100, digits = 0)) %>%
    ungroup() %>%
    ggplot(aes(y = n, x = respondent_type, fill = A_DM_know_and_inter)) +
    geom_col(position = "dodge")  + 
    scale_x_discrete(labels = c("All\nTogether", "Deputy\nMayor", "Mayor", "Opposition\nMember", "Secretary\nGeneral")) +
    scale_fill_manual(values = c("grey95","grey75","grey65", "grey55", "grey45", "grey35"), 
                        labels = c("Missing",
                                   "Doesn't know the CBO",
                                   'Has heard about CBO and...',
                                   '...knows at least one member and...', 
                                   '...knows that CBO has approached admin. or council and...', 
                                   '...has been approached by CBO')) + 
    labs(
      y = "Number of decision makers", 
      x = "Type of decision maker", 
      fill = "Breadth of DMs' knowledge and interaction with CBOs"
    ) +
    theme_minimal() +
    theme(text = element_text(size=11, family="Times"), 
          legend.title=element_text(size=11), 
          legend.text=element_text(size=8))  +
    theme(plot.margin=grid::unit(c(0,0,0,0), "mm")) 
  
  ggsave(width = 7, height = 4, filename = paste0(path, "H1_", "A_DM_know_and_inter.png"), device = png,  dpi=200)
  
  rm(forplot)  
  
# 4. A_game_group_contrib --------------- ######
  
  ggplot(CBO_groups_final_IND %>% 
                    drop_na(A_game_group_contrib, contributions_late) %>% 
                    group_by(appcode) %>% #Taking the CBO-level average
                    mutate(A_game_group_contrib = mean(A_game_group_contrib, na.rm = T)) %>% 
                    ungroup() %>%
                    distinct(appcode, .keep_all = T) %>% #Putting it at the CBO level
                    filter(reshaped_id == "A_game_groupcontrib_1"), 
                  
                  aes(x = A_game_group_contrib)) +
     geom_histogram(binwidth = 0.01) +
     labs(x = "Voluntary contribution as proportion of endowment.", 
          y = "Percentage share of CBO members") + 
     theme_minimal() +
     theme(text = element_text(size=11, family="Times")) +
    theme(plot.margin=grid::unit(c(0,0,0,0), "mm"))
  
  ggsave(width = 7, height = 3, filename = paste0(path, "H2_", "A_game_group_contrib.png"), device = png,  dpi=200)
  
  
# 5. meetings_general & meetings_executive --------------- ######
  
  plot1 <- ggplot(CBO_groups_final %>% drop_na(meetings_general),
                  aes(x = meetings_general)) + 
    geom_histogram(binwidth = 1) + 
    labs(
      x = "Number of general membership meetings \n held by the CBO in 2020", 
      y = "Number of CBOs"
    ) +
    theme_minimal() +
    scale_y_continuous(limits = c(0,200)) + 
    theme(text = element_text(size=11, family="Times"))
  
  plot2 <- ggplot(CBO_groups_final %>% drop_na(meetings_executive),
                  aes(x = meetings_executive)) + 
    geom_histogram() + 
    labs(
      x = "Number of executive board meetings \n held by the CBO in 2020", 
    ) +
    theme_minimal() +
    scale_y_continuous(limits = c(0,200)) + 
    theme(text = element_text(size=11, family="Times"), 
          axis.title.y=element_blank())
  
  ggarrange(plot1, plot2, align = "hv") +
    theme(plot.margin=grid::unit(c(0,0,0,0), "mm"))
  
  ggsave(width = 7, height = 3, filename = paste0(path, "H2_", "meetings.png"), device = png,  dpi=200)
  
  
# 6. A_log_members_total_after --------------- ######
  
  ##Distribution (displaying percentage change instead of number of member at the time of interview)
  forplot <- CBO_groups_final %>%
    rowwise() %>% 
    mutate(todrop_pcchange = ifelse(!is.na(A_log_members_total_after), ((B_members_total_after - B_members_total_before)/B_members_total_before), NA)) %>% #Adding conditions to remove the two observations that were put as NA in log transformation because numbers did not make sense (total < or = 0)
    ungroup()
  
  ggplot(forplot %>% drop_na(todrop_pcchange),
                  aes(x = todrop_pcchange*100)) + 
      geom_histogram(binwidth = 1) + 
      labs(
        x = "Percentage change in the number of CBO members (from start of 2020 to 2021 Q3)", 
        y = "Number of CBOs"
      ) +
      theme_minimal() +
      theme(text = element_text(size=11, family="Times")) +
    theme(plot.margin=grid::unit(c(0,0,0,0), "mm"))
  
  ggsave(width = 7, height = 3, filename = paste0(path, "H2_", "A_log_members_total_after.png"), device = png,  dpi=200)
  rm(forplot)
  
  
# 7. covid variables --------------- ######
  
  pct_format = scales::percent_format(accuracy = .1)

  ##Scatter plot
  plot1 <- ggplot(CBO_groups_final,
                  aes(x = covid_policy)) + 
    geom_bar() +
    labs(
      x = "CBO has adopted COVID-19 policy", 
      y = "Number of CBOs"
    ) + 
    scale_x_discrete(labels = c('No','Yes')) +
    theme_minimal() +
    geom_text(aes(
      label = sprintf('%d \n (%s)',
                      ..count..,
                      pct_format(..count.. / sum(..count..)))),
      stat = 'count',
      nudge_y = .2,
      colour = 'black',
      size = 3, 
      vjust = -0.5) + 
    theme_minimal() +
    theme(text = element_text(size=11, family="Times")) +
    scale_y_continuous(limits = c(0,700)) + 
    theme(plot.margin=grid::unit(c(0,0,0,0), "mm"))
  
  plot2 <- ggplot(CBO_groups_final,
                  aes(x = covid_adaptation)) + 
    geom_bar() +
    labs(
      x = "CBO has seized COVID-related opportunities", 
      y = "Number of CBOs"
    ) +
    scale_x_discrete(labels = c('Has not led to any new activities',
                                'Has prompted some new activities', 
                                'Caused you to start a lot of new activities', 
                                "Completely redefined your organization's activities"),
                     guide = guide_axis(angle = 45)) +
    theme_minimal() +
    geom_text(aes(
      label = sprintf('%d \n (%s)',
                      ..count..,
                      pct_format(..count.. / sum(..count..)))),
      stat = 'count',
      nudge_y = .2,
      colour = 'black',
      size = 3, 
      vjust = -0.5) + 
    theme(text = element_text(size=11, family="Times")) +
    scale_y_continuous(limits = c(0,700))
  
  ggarrange(plot1, plot2, align = "hv") +
    theme(plot.margin=grid::unit(c(0,0,0,0), "mm"))
  
  ggsave(width = 7, height = 4, filename = paste0(path, "H2_", "covid.png"), device = png,  dpi=200)
  
# 8. cohesion --------------- ######
  
  pct_format = scales::percent_format(accuracy = .1)
  
  plot1 <- ggplot((CBO_individuals_final %>%
                     select(cbo_conflict) %>%
                     mutate(cbo_conflict = as.character(cbo_conflict)) %>%
                     mutate(cbo_conflict = ifelse(is.na(cbo_conflict), "RFS/Don't Know", as.character(cbo_conflict))) %>% #Re-integrate NAs as refuse to answer or don't know (like originally)
                     mutate(cbo_conflict = as.factor(cbo_conflict))),
                  aes(x = cbo_conflict)) + 
    geom_bar() + 
    labs(
      x = "Conflict in CBO", 
      y = "Number of CBO members"
    ) + 
    scale_x_discrete(labels = c('No','Yes', "RF/Don't Know")) + 
    geom_text(aes(
      label = sprintf('%d \n (%s)',
                      ..count..,
                      pct_format(..count.. / sum(..count..)))),
      stat = 'count',
      nudge_y = .2,
      colour = 'black',
      size = 2, 
      vjust = -0.2) + 
    theme_minimal() +
    theme(text = element_text(size=11, family="Times")) + 
    scale_y_continuous(limits = c(0,4200)) 
  
  plot2 <- ggplot(CBO_individuals_final,
                  aes(x = cbo_satisfaction)) + 
    labs(
      x = "Satisfaction with the leadership",
      y = "Number of CBO members"
    ) +
    geom_bar() +
    scale_x_discrete(labels = c('Very dissatisfied',
                                'Somewhat dissatisfied', 
                                'Somewhat satisfied', 
                                'Very satisfied'),
                     guide = guide_axis(angle = 45)) +
    geom_text(aes(
      label = sprintf('%d \n (%s)',
                      ..count..,
                      pct_format(..count.. / sum(..count..)))),
      stat = 'count',
      nudge_y = .2,
      colour = 'black',
      size = 2, 
      vjust = -0.5) + 
    theme_minimal() +
    theme(text = element_text(size=11, family="Times"), 
          axis.title.y=element_blank()) + 
    scale_y_continuous(limits = c(0,4200)) 
  
  plot3 <- ggplot(CBO_individuals_final,
                  aes(x = cbo_enthusiasm)) + 
    labs(
      x = "General satisfaction", 
      y = "Number of CBO members"
    ) +
    geom_bar() +
    scale_x_discrete(labels = c('Very frustrated with it',
                                'A bit frustrated with it', 
                                'Feeling neutral about it', 
                                'Feeling positive about it', 
                                'Feeling very enthusiastic about it'),
                     guide = guide_axis(angle = 45)) +
    geom_text(aes(
      label = sprintf('%d \n (%s)',
                      ..count..,
                      pct_format(..count.. / sum(..count..)))),
      stat = 'count',
      nudge_y = .2,
      colour = 'black',
      size = 2, 
      vjust = -0.5) + 
    theme_minimal() +
    theme(text = element_text(size=11, family="Times"), 
          axis.title.y=element_blank()) + 
    scale_y_continuous(limits = c(0,4200)) 
  
  ggarrange(plot1, plot2, plot3, 
            ncol=3, 
            nrow=1, 
            widths = c(1, 1, 1), 
            align = "hv") +
    theme(plot.margin=grid::unit(c(0,0,0,0), "mm"))
  
  ggsave(width = 7, height = 4.1, filename = paste0(path, "H2_", "cohesion.png"), device = png,  dpi=200)
  
# 9. Hypothesis 3 variables --------------- ######
  
  pct_format = scales::percent_format(accuracy = .1)
  
  plot1 <- ggplot(DM_final,
                  aes(x = factor(A_bin_decideurs_important))) + 
    geom_bar() + 
    labs(
      x = "...most important actors to keep happy, \n in order to maintain influence", 
      y = "Number of decision makers"
    ) + 
    scale_x_discrete(labels = c('No','Yes', "Missing")) + 
    geom_text(aes(
      label = sprintf('%d \n (%s)',
                      ..count..,
                      pct_format(..count.. / sum(..count..)))),
      stat = 'count',
      nudge_y = .2,
      colour = 'black',
      size = 2.5, 
      vjust = -0.2) + 
    theme_minimal() +
    theme(text = element_text(size=11, family="Times")) + 
    scale_y_continuous(limits = c(0,700)) 
  
  plot2 <- ggplot(DM_final,
                  aes(x = factor(A_bin_decideurs_justify))) + 
    geom_bar() + 
    labs(
      x = "...actors to whom municipal decision makers \n spend the most effort justifying their decisions", 
      y = "Number of decision makers"
    ) + 
    scale_x_discrete(labels = c('No','Yes', "Missing")) + 
    geom_text(aes(
      label = sprintf('%d \n (%s)',
                      ..count..,
                      pct_format(..count.. / sum(..count..)))),
      stat = 'count',
      nudge_y = .2,
      colour = 'black',
      size = 2.5, 
      vjust = -0.5) + 
    theme_minimal() +
    theme(text = element_text(size=11, family="Times"), 
          axis.title.y=element_blank()) + 
    scale_y_continuous(limits = c(0,700))
  
  plot <- ggarrange(plot1, plot2,
            widths = c(0.5, 0.5), 
            align = "hv") +
    theme(plot.margin=grid::unit(c(0,0,0,0), "mm"))
  
  annotate_figure(plot, top = text_grob("Community groups and civil society are among the three...", 
                  size = 11, family = "Times"))
  
  rm(plot, plot1, plot2)
  
  ggsave(width = 7, height = 4, filename = paste0(path, "H3_", "1.png"), device = png,  dpi=200)

  ggplot(DM_final,
         aes(x = factor(pressure_civilsociety))) + 
    labs(
      x = "Perceived likelihood of civil society pressure if their municipality \n fails to delivery on its responsibilities without good justification", 
      y = "Number of decision makers"
    ) +
    geom_bar() +
    scale_x_discrete(labels = c('Impossible',
                                'Very unlikely', 
                                'Somewhat unlikely', 
                                'Somewhat likely', 
                                'Very likely', 
                                'Certain', 
                                'Missing'),
                     guide = guide_axis(angle = 45)) +
    geom_text(aes(
      label = sprintf('%d \n (%s)',
                      ..count..,
                      pct_format(..count.. / sum(..count..)))),
      stat = 'count',
      nudge_y = .2,
      colour = 'black',
      size = 2.5, 
      vjust = -0.2) + 
    theme_minimal() +
    theme(text = element_text(size=11, family="Times")) + 
    scale_y_continuous(limits = c(0,700))
  
  ggsave(width = 7, height = 3, filename = paste0(path, "H3_", "2.png"), device = png,  dpi=200)
  
  
# 10. A_breadth_awareness_sm_indicators --------------- ######
  
  ggplot(DM_final %>% drop_na(A_breadth_awareness_sm_indicators),
         aes(x = A_breadth_awareness_sm_indicators)) + 
    geom_histogram(binwidth = 1) + 
    labs(
      x = "Number of SUPERMUN indicators Decision Makers were able to correctly recall from memory", 
      y = "Number of decision makers"
    ) +
    theme_minimal() +
    facet_wrap(factor((DM_final %>% drop_na(A_breadth_awareness_sm_indicators))$respondent_type)) +
    theme(text = element_text(size=11, family="Times"))
  
  ggsave(width = 7, height = 3, filename = paste0(path, "H4_", "A_breadth_awareness_sm_indicators.png"), device = png,  dpi=200)
  
# 12. A_abs_deviation_relative_perf --------------- ######
  
  ggplot(DM_final %>% drop_na(A_abs_deviation_relative_perf),
         aes(x = A_abs_deviation_relative_perf)) + 
    geom_histogram(binwidth = 1) + 
    labs(
      x = "Sum of absolute deviations between the perceived and actual municipal performance quintiles, \n across all groups of indicators, in 2018", 
      y = "Number of decision makers"
    ) +
    theme_minimal() +
    facet_wrap(factor((DM_final %>% drop_na(A_abs_deviation_relative_perf))$respondent_type)) +
    theme(text = element_text(size=11, family="Times")) +
    theme(plot.margin=grid::unit(c(0,0,0,0), "mm"))
  
  ggsave(width = 7, height = 3, filename = paste0(path, "H4_", "A_abs_deviation_relative_perf.png"), device = png,  dpi=200)
  
# 11. Hypothesis 5 - A_total_points_all_2020: Aggregate SUPERMUN municipal performance score in 2020 --------------- ######
  
  ggplot(muni_level_final %>% drop_na(A_total_points_all_2020),
         aes(x = A_total_points_all_2020)) + 
    geom_histogram(binwidth = 1) + 
    labs(
      x = "Aggregate SUPERMUN municipal performance score, in 2020", 
      y = "Number of municipalities"
    ) +
    theme_minimal() +
    theme(text = element_text(size=11, family="Times")) +
    theme(plot.margin=grid::unit(c(0,0,0,0), "mm"))
  
  ggsave(width = 7, height = 3, filename = paste0(path, "H5_", "A_total_points_all_2020.png"), device = png,  dpi=200) 
  
  
# END --------------- ######

  
  